/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.multimedia;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import symantec.itools.lang.OS;

public class Plasma
extends Canvas
implements Runnable {
    int[] xpoints;
    int[] ypoints;
    byte[] red;
    byte[] green;
    byte[] blue;
    byte[] buffer;
    byte[] costab;
    Dimension dim;
    transient IndexColorModel cModel;
    transient Image img;
    byte x1;
    byte x2;
    byte y1;
    byte y2;
    byte x1mod = (byte)6;
    byte x2mod = (byte)8;
    byte y1mod = (byte)6;
    byte y2mod = (byte)4;
    boolean keepGoing = true;
    boolean suspended = false;
    boolean stopThread = false;
    boolean Threadstopped = false;
    transient Thread displayThread;
    private boolean previewMode = false;
    private transient int iteration;
    private final transient int MAX_ITERATION_GC = 25;

    public Plasma() {
        this.xpoints = new int[5];
        this.ypoints = new int[5];
        this.red = new byte[128];
        this.green = new byte[128];
        this.blue = new byte[128];
        this.dopalette();
        this.cModel = new IndexColorModel(7, 128, this.red, this.green, this.blue);
        this.costab = new byte[256];
        this.setupcos();
        this.createBuffer();
    }

    void createBuffer() {
        this.dim = this.size();
        this.buffer = new byte[this.dim.width * (this.dim.height + 100)];
        this.img = null;
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.displayThread = new Thread(this);
        this.displayThread.setPriority(1);
        this.displayThread.start();
    }

    public synchronized void removeNotify() {
        this.keepGoing = false;
        this.stopThread = false;
        if (this.displayThread != null) {
            this.displayThread.setPriority(10);
            this.displayThread.resume();
        }
        while (this.displayThread != null) {
            try {
                Thread.sleep(40L);
            }
            catch (Exception exception) {}
        }
        super.removeNotify();
    }

    public void startPlasma() {
        this.suspended = false;
        this.show();
    }

    public void stopPlasma() {
        this.suspended = true;
    }

    public synchronized void show() {
        if (this.displayThread != null) {
            if (this.stopThread) {
                this.stopThread = false;
            } else {
                this.displayThread.setPriority(10);
                this.displayThread.resume();
            }
        }
    }

    public synchronized void hide() {
        if (!this.Threadstopped) {
            this.stopThread = true;
            this.displayThread.setPriority(10);
        }
    }

    public synchronized void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.createBuffer();
    }

    public void setPreviewMode(boolean f) {
        this.previewMode = f;
        this.repaint();
    }

    public boolean getPreviewMode() {
        return this.previewMode;
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    public void run() {
        while (this.keepGoing) {
            if (!(this.stopThread || this.suspended || !this.previewMode && Beans.isDesignTime())) {
                this.repaint();
            }
            if (this.stopThread) {
                super.hide();
                this.Threadstopped = true;
                this.displayThread.setPriority(1);
                this.displayThread.suspend();
                this.Threadstopped = false;
                if (!this.keepGoing) continue;
                super.show();
                this.displayThread.setPriority(1);
                continue;
            }
            if (!this.keepGoing) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        this.displayThread = null;
    }

    public void paint(Graphics g) {
        if (!(this.suspended || !this.previewMode && Beans.isDesignTime())) {
            this.moveplasma();
        }
        if (this.img == null) {
            this.drawplasma();
            try {
                this.img = this.createImage(new MemoryImageSource(this.dim.width, this.dim.height, (ColorModel)this.cModel, this.buffer, 0, this.dim.width));
            }
            catch (Exception exception) {}
        }
        if (OS.isMacintosh()) {
            g.clipRect(0, 0, this.dim.width, this.dim.height);
        }
        g.drawRect(0, 0, this.dim.width - 1, this.dim.height - 1);
        g.clipRect(1, 1, this.dim.width - 2, this.dim.height - 2);
        if (this.img != null) {
            if (OS.isMacintosh()) {
                g.drawImage(this.img, 1, 1, null);
            } else {
                g.drawImage(this.img, 1, 1, this);
            }
        }
        if (++this.iteration > 25) {
            System.gc();
            this.iteration = 0;
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void drawplasma() {
        char t3 = (char)this.y1;
        char t4 = (char)this.y2;
        int j = 0;
        while (j < this.dim.height * this.dim.width) {
            char t1 = (char)this.x1;
            char t2 = (char)this.x2;
            int i = 0;
            while (i < this.dim.width) {
                this.buffer[i + j] = (byte)(this.costab[t1 & 0xFF] + this.costab[t2 & 0xFF] + this.costab[t3 & 0xFF] + this.costab[t4 & 0xFF]);
                this.buffer[i + j + 1] = this.buffer[i + j];
                this.buffer[i + j + 2] = this.buffer[i + j];
                this.buffer[i + j + 3] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + 1] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + 2] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + 3] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + this.dim.width] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + this.dim.width + 1] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + this.dim.width + 2] = this.buffer[i + j];
                this.buffer[i + j + this.dim.width + this.dim.width + 3] = this.buffer[i + j];
                t1 = (char)(t1 + this.x1mod);
                t2 = (char)(t2 + this.x2mod);
                i += 4;
            }
            t3 = (char)(t3 + this.y1mod);
            t4 = (char)(t4 + this.y2mod);
            j += this.dim.width + this.dim.width + this.dim.width;
        }
    }

    public void moveplasma() {
        this.x1 = (byte)(this.x1 - this.x1mod * 2);
        this.y1 = (byte)(this.y1 + this.y1mod * 2);
        this.x1 = (byte)(this.x1 + (byte)(Math.random() * 3.0));
        this.x2 = (byte)(this.x2 - (byte)(Math.random() * 4.0));
        this.y1 = (byte)(this.y1 + (byte)(Math.random() * 3.0));
        this.y2 = (byte)(this.y2 - (byte)(Math.random() * 5.0));
        if (this.img != null) {
            this.img.flush();
        }
        this.img = null;
    }

    public void dopalette() {
        int i = 0;
        while (i < 32) {
            this.red[i] = -1;
            this.green[i] = 0;
            this.blue[i] = (byte)(i * 8);
            ++i;
        }
        i = 32;
        while (i < 96) {
            this.red[i] = (byte)(255 - i * 8);
            this.green[i] = (byte)(i * 8);
            this.blue[i] = -1;
            ++i;
        }
        i = 64;
        while (i < 96) {
            this.red[i] = 0;
            this.green[i] = -1;
            this.blue[i] = (byte)(255 - i * 8);
            ++i;
        }
        i = 96;
        while (i < 128) {
            this.red[i] = (byte)(i * 8);
            this.green[i] = (byte)(255 - i * 8);
            this.blue[i] = 0;
            ++i;
        }
    }

    public void setupcos() {
        int i = 0;
        while (i < 256) {
            this.costab[i] = (byte)(16.0 + Math.cos((double)i * 360.0 / 255.0 / 180.0 * Math.PI) * 15.0);
            ++i;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.cModel = new IndexColorModel(7, 128, this.red, this.green, this.blue);
    }
}

